﻿using System;
using System.Text;
using System.Xml;

namespace AHOBPR_Job_Runner.DasXml
{
    [Serializable]
    public class Document
    {
        public DateTime CreationDate { get; set; }
        public String DescriptionText { get; set; } 
        public String FormatText { get; set; }
        public DocumentIdentification AhobprId { get; set; }
        public DocumentIdentification LoincId { get; set; }
        public DateTime PostDate { get; set; }
        public String Source { get; set; }
        public String Status { get; set; }
        public String TitleText { get; set; }
        public String LanguageCode { get; set; }

        public Document()
        {
            DescriptionText = "Airborne Hazard and Open Burn Pit Assessment Questionnaire";
            FormatText = "application/pdf";
            Source = "AHOBPR";
            Status = "Completed";
            LanguageCode = "eng";
            CreationDate = DateTime.Now;
            PostDate = DateTime.Now;
            AhobprId = new DocumentIdentification() { CategoryText = "Questionnaire Response Id", IdentificationSourceText = "AHOBPR" };
            LoincId = new DocumentIdentification() { Id = "64285-0", CategoryText = "LOINC" };
        }

        public void GetXml(XmlWriter writer)
        {
            String prefix = "nc";
            writer.WriteStartElement(prefix, "Document", prefix);
            writer.WriteWhitespace("\r\n\t\t\t");

            //Creation Date:
            {
                writer.WriteStartElement(prefix, "DocumentCreationDate", prefix);
                writer.WriteWhitespace("\r\n\t\t\t\t");
                {
                    writer.WriteDateTime(prefix, CreationDate);
                }
                writer.WriteEndElement();
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Description Text:
            {
                writer.WriteElementString(prefix, "DocumentDescriptionText", prefix, DescriptionText);
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Format Text:
            {
                writer.WriteElementString(prefix, "DocumentFormatText", prefix, FormatText);
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //AHOBPR ID:
            {
                AhobprId.GetXml(writer);
            }

            //LOINC ID:
            {
                LoincId.GetXml(writer);
            }

            //Post Date:
            {
                writer.WriteStartElement(prefix, "DocumentPostDate", prefix);
                writer.WriteWhitespace("\r\n\t\t\t\t");
                {
                    writer.WriteDateTime(prefix, PostDate);
                }
                writer.WriteEndElement();
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Source:
            {
                writer.WriteStartElement(prefix, "DocumentSource", prefix);
                writer.WriteWhitespace("\r\n\t\t\t\t");
                {
                    writer.WriteStartElement(prefix, "EntityOrganization", prefix);
                    writer.WriteWhitespace("\r\n\t\t\t\t\t");
                    {
                        writer.WriteElementString(prefix, "OrganizationName", prefix, Source);
                        writer.WriteWhitespace("\r\n\t\t\t\t");
                    }
                    writer.WriteEndElement();
                    writer.WriteWhitespace("\r\n\t\t\t");
                }
                writer.WriteEndElement();
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Status:
            {
                writer.WriteStartElement(prefix, "DocumentStatus", prefix);
                writer.WriteWhitespace("\r\n\t\t\t\t");
                {
                    writer.WriteElementString(prefix, "StatusText", prefix, Status);
                    writer.WriteWhitespace("\r\n\t\t\t");
                }
                writer.WriteEndElement();
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Title:
            {
                writer.WriteElementString(prefix, "DocumentTitleText", prefix, TitleText);
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Language Code:
            {
                writer.WriteElementString(prefix, "DocumentLanguageCode", prefix, LanguageCode);
                writer.WriteWhitespace("\r\n\t\t");
            }

            writer.WriteEndElement();
            writer.WriteWhitespace("\r\n\t\t");
        }
    }

    public static class Extensions
    {
        public static void WriteDateTime(this XmlWriter writer, String prefix, DateTime date)
        {
            writer.WriteElementString(prefix, "DateTime", prefix, date.ToString("yyyy-MM-ddThh:mm:ssZ"));
            writer.WriteWhitespace("\r\n\t\t\t");
        }
        public static void WriteDate(this XmlWriter writer, String prefix, DateTime date)
        {
            writer.WriteElementString(prefix, "Date", prefix, date.ToString("yyyy-MM-dd"));
            writer.WriteWhitespace("\r\n\t\t\t");
        }
    }
}